#!/bin/bash

# cdvdlabel.sh
#
# Usage: cdvdlabel.sh <device file> <label file> <log file>
#
# Error Return Codes:
# 1 - No label found
# 2 - Major failure
#
# Author: C. Schuck
# 05/20/2003  P. Provost  Changed to use grep -q

DEVICEFILE=$1
LABELFILE=$2
LOGFILE=$3

echo "-> cdvdlabel.sh" >> $LOGFILE
echo "Getting the label from the CD-ROM or DVD-RAM at $DEVICEFILE for `date`" >> $LOGFILE

actzTrace "XMDA   T: -> cdvdlabel.sh"
actzTrace "XMDA   F: cdvdlabel.sh: Getting the label from the CD-ROM or DVD-RAM at $DEVICEFILE for `date`"

# First try to retrieve the CD-ROM or DVD-RAM label using chkudf
if chkudf $DEVICEFILE > $LABELFILE 2>&1; then
    if ! grep -q -i 'Volume Identifier:' $LABELFILE 2>&1; then
        actzTrace "XMDA   F: cdvdlabel.sh: Failed to retrieve the label using chkudf...possibly a CD-ROM or not UDF formatted"
        echo "Failed to retrieve the label using chkudf...possibly a CD-ROM or not UDF formatted" >> $LOGFILE
        # If the media is a CD-ROM, then try to retrieve the CD-ROM label using the dd command 
        if dd if=$DEVICEFILE bs=1 skip=32808 count=32 > $LABELFILE 2>&1; then
            actzTrace "XMDA   F: cdvdlabel.sh: Successfully retrieved the label using dd."
            echo "Successfully retrieved the label using dd." >> $LOGFILE
            echo "Label File Listing:" >> $LOGFILE
            cat $LABELFILE >> $LOGFILE
        else
            actzTrace "XMDA   F: cdvdlabel.sh: Failed to retrieve the label using dd."
            echo "Failed to retrieve the label using dd." >> $LOGFILE
            exit 1
        fi
    else
        cp $LABELFILE /tmp/hmc/mediasvc/cdvdlabel.out
        grep -i '(M) Volume Identifier:' /tmp/hmc/mediasvc/cdvdlabel.out > $LABELFILE
        rm -f /tmp/hmc/mediasvc/cdvdlabel.out
        
        actzTrace "XMDA   F: cdvdlabel.sh: Successfully retrieved label using chkudf."
        echo "Successfully retrieved label using chkudf." >> $LOGFILE    
        echo "Label File Listing:" >> $LOGFILE
        cat $LABELFILE >> $LOGFILE
    fi
else
    actzTrace "XMDA   F: cdvdlabel.sh: Failed to retrieve the label using chkudf."
    echo "Failed to retrieve the label using chkudf." >> $LOGFILE
    exit 2
fi

actzTrace "XMDA   T: <- cdvdlabel.sh"
echo "<- cdvdlabel.sh" >> $LOGFILE
echo "" >> $LOGFILE

exit 0

